* ==============================================================================
* Script:  2_data_analysis.do
* Purpose: a. Runs the regressions that are presented in Tables 3 - 6. 
*
* ==============================================================================
cd "$translog_gvty\processed"

use translog_gravity, clear
  bys i: egen sps_i = sum(sps) // We include exporting and importing countries where an STC was active at least once over the length of the panel
  bys j: egen sps_j = sum(sps)
  drop if sps_i == 0 
  drop if sps_j == 0
  drop sps_i sps_j
  
  egen id = group(i j)
  xtset id t
  
  gen      lsps = log(1 + sps)
  gen byte dsps = sps > 0
  gen ltariff = log(1 + tariff) 
  gen lv		 = log(v)
  egen it 	 = group(i t) 
  egen jt 	 = group(j t) 
  egen ij  	 = group(i j)
	
* 1. Translog gravity estimations (Table 2)
* ===============================
  bys j t: egen y_jt = sum(v)
  drop if y_jt == 0
  gen s_ijt = [(v / y_jt) / n2_it] * 100  // generate import shares
  gen share =  (v / y_jt) * 100 // generate import shares
  
  eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
  eststo:  reghdfe s_ijt dsps ltariff rta,			 absorb(jt it ij) cluster(id)
  outreg2 [*] using "$translog_gvty/results/tables/Table2.xls", dec(3) replace
  estimates clear
  
* 2. Treat STCs as unilateral (Table 4)
* ===========================
* Doing this means there is no bilateral variation in the sps. So we control for control for standard gravity variables
  bys j t: egen new = sum(sps)
  gen dnew = 1 if new != 0 
  replace dnew = 0 if dnew == .
  gen ldist = log(distcap) 
  global xij ldist colony comlangoff contig 
  eststo:  reghdfe s_ijt dnew $xij ltariff rta if s_ijt>0, absorb(j it t) cluster(id)
  eststo:  reghdfe s_ijt dnew $xij ltariff rta           , absorb(j it t) cluster(id)

  outreg2 [*] using "$translog_gvty/results/tables/Table4.xls", dec(3) replace
  estimates clear
 

* 5. CES with heterogeneous effects (Table 6)
* =================================
  eststo: ppmlhdfe  v dsps ltariff rta, absorb(jt it ij) cluster(id)
		  ppmlhdfe  v,       absorb(jt it ij) cluster(id) d
		  gen predictedshares = v - _ppmlhdfe_d // difference between the actual value and residual
		  gen dsps_sharehat = dsps * predictedshares
  eststo: ppmlhdfe  v $xijt dsps_sharehat, 			absorb(jt it ij) cluster(id)
		  xtile interval = predictedshares, nquantiles(4) 
		  tab interval, gen(share_interval)
		  gen dsps_interval1 = dsps*share_interval1
		  gen dsps_interval2 = dsps*share_interval2
		  gen dsps_interval3 = dsps*share_interval3
		  gen dsps_interval4 = dsps*share_interval4
  eststo: ppmlhdfe  v dsps_interval1 dsps_interval2 dsps_interval3 dsps_interval4 ltariff rta ,absorb(jt it ij) cluster(id)
  outreg2 [*] using "$translog_gvty/results/tables/Table6.xls", dec(3) replace
  estimates clear
  
* Appendix
* ========
* CES gravity model
* =================
  eststo:  reghdfe lv dsps ltariff rta, absorb(jt it ij) cluster(id)
  eststo: ppmlhdfe  v dsps ltariff rta if v>0, absorb(jt it ij) cluster(id)
  eststo: ppmlhdfe  v dsps ltariff rta, absorb(jt it ij) cluster(id)
  outreg2 [*] using "$translog_gvty/results/tables/TableA2.xls", dec(3) replace
  estimates clear
  
* 4. Using the one year lag of SPS measures
* =========================================
  bys i j (t): gen ldsps = dsps[_n-1]
  eststo:  reghdfe s_ijt ldsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
  *eststo:  reghdfe s_ijt ldsps ltariff rta,			 absorb(jt it ij) cluster(id)
  *eststo: ppmlhdfe s_ijt ldsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
  *eststo: ppmlhdfe s_ijt ldsps ltariff rta,			 absorb(jt it ij) cluster(id)
  *outreg2 [*] using "$translog_gvty/results/tables/Table5.xls", dec(3) replace
  *estimates clear
  
* Log of SPS
 eststo: ppmlhdfe s_ijt lsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)

* Drop EU-US trade
* ================  
  gen eu15_exp = 1 if  (i=="FRA" |i=="ITA" |i=="DEU" |i=="BEL"| i=="BLX" |i=="LUX" |i=="GBR" |i=="DNK" |i=="IRL"|i=="ESP" |i=="PRT" |i=="GRC"  |i=="AUT" |i=="SWE" |i=="FIN"|i=="DEU"|i=="NLD")
foreach c in HUN LVA LTU POL SVK SVN CZE EST CYP MLT{
 replace eu15_exp = 1 if i == "`c'" & t >=2004
}
 replace eu15_exp = 1 if i == "BGR" & t >= 2007
 replace eu15_exp = 1 if i == "ROU" & t >= 2007
 replace eu15_exp = 1 if i == "HRV" & t >= 2013
  
  gen eu15_imp = 1 if j ==  "EU15"
  foreach c in HUN LVA LTU POL SVK SVN CZE EST CYP MLT{
  replace eu15_imp = 1 if j == "`c'" & t >=2004
}
 replace eu15_imp = 1 if j == "BGR" & t >= 2007
 replace eu15_imp = 1 if j == "ROU" & t >= 2007
 replace eu15_imp = 1 if j == "HRV" & t >= 2013
 
  gen eu_us = 1 if j == "USA"  & eu15_exp == 1
  gen us_eu = 1 if eu15_imp == 1 & i == "USA"
  eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0 & eu_us != 1 & us_eu != 1 , absorb(jt it ij) cluster(id)
  *eststo:  reghdfe s_ijt dsps ltariff rta if           j != "USA" & i != "USA" & j != "EU15" & eu15_exp != 1, absorb(jt it ij) cluster(id)
  *outreg2 [*] using "$translog_gvty/results/tables/Table_EU_US.xls", dec(3) replace

  
* Translog with PPML
* ==================
  eststo: ppmlhdfe s_ijt dsps ltariff rta if s_ijt>0, absorb(jt it ij) cluster(id)
  *eststo: ppmlhdfe s_ijt dsps ltariff rta,			  absorb(jt it ij) cluster(id)
  *outreg2 [*] using "$translog_gvty/results/tables/TableA5.xls", dec(3) replace
  *estimates clear
  outreg2 [*] using "$translog_gvty/results/tables/robustness.xls", dec(3) replace
  estimates clear
  
* By income classes (Table 5)
* =================
  merge m:1 i using income_i, keep(1 3) nogen 
  rename Incomegroup inc_exp
  merge m:1 j using income_j, keep(1 3) nogen 
  rename Incomegroup inc_imp
  
  replace inc_exp = "Low income" if inc_exp != "High income"
  replace inc_imp = "Low income" if inc_imp != "High income"
  
  
  eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0 & inc_exp == "Low income"  & inc_imp == "High income", absorb(jt it ij) cluster(id) // South - North
  eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0 & inc_exp == "High income" & inc_imp == "Low income", absorb(jt it ij) cluster(id)  // North - South
  eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0 & inc_exp == "Low income" & inc_imp == "Low income", absorb(jt it ij) cluster(id)   // South - South
  eststo:  reghdfe s_ijt dsps ltariff rta if s_ijt>0 & inc_exp == "High income" & inc_imp == "High income", absorb(jt it ij) cluster(id) // North - North
  
  gen elasticity = ((_b[dsps]) / s_ijt) if e(sample) == 1 
  drop if elasticity ==. 
  *egen p10 = pctile(s_ijt), p(10)
  *egen p20 = pctile(s_ijt), p(20)
  egen p30 = pctile(s_ijt), p(30)
  egen p50 = pctile(s_ijt), p(50)
  egen p90 = pctile(s_ijt), p(90)
  egen mean_sh = mean(s_ijt)
		
  *gen elasticities10   = (_b[dsps]) / p10
  *gen elasticities20   = (_b[dsps]) / p20
  gen elasticities30   = (_b[dsps]) / p30
  gen elasticities50   = (_b[dsps]) / p50
  gen elasticities90   = (_b[dsps]) / p90
  gen elasticitiesMean = (_b[dsps]) / mean_sh
  
  sum elastici* // These are the elasticities reported at the bottom of each regression table
  drop p* mean_sh elasticit*
  
  outreg2 [*] using "$translog_gvty/results/tables/Table5.xls", dec(3) ctitle(South-North;North-South;South-South;North-North) replace




  